import('com.nx.assist.lua.LuaEngine')

-- ؼܲ
local loader = LuaEngine.loadApk("encrypt.apk")
local AESUtilsBase = loader.loadClass("com.lianxin.encrypt.AESUtilsBase")

local FNKY = {}

-- ʱֵ
local TIMEOUT = 10 * 1000
local DEBUG = true

-- ĬϴӦ
local RESPONSE = {
	["ERROR_SIGNATURE"] = "ǩУʧ",
	["ERROR_STATUS"] = "״̬Уʧ",
	["ERROR_TIME"] = "ʱУʧ"
}

-- ʼͻ
-- @param app_id: ӦID
-- @param base_url: APIURL
-- @param use_encryption: Ƿʹü (true/false)
-- @param encrypt_key: ӽܳ
function FNKY.init(app_id, base_url, use_encryption, encrypt_key)
    FNKY.app_id = app_id
    FNKY.base_url = base_url
    FNKY.use_encryption = use_encryption
    FNKY.encrypt_key = encrypt_key
    FNKY.token = nil
	FNKY.init_token()
end





--------------------------ʼ----------------------------------





-- 
-- @param api: API
-- @param params: 
-- @return response: Ӧ
function FNKY.send_request(api, params)
    local url = FNKY.base_url .. "?AppId=" .. FNKY.app_id

	DebugPrint("url:", url)

    params.Api = api
    params.Time = os.time()
    params.Status = math.random(10000, 99999)
	FNKY.params = params

    local body
    if FNKY.use_encryption then
        body = FNKY.encrypt_request(params)
    else
        body = jsonLib.encode(params)
    end

	DebugPrint(":", body)

    local headers = {}
    headers["Content-Type"] = "application/json"
	headers["Content-Length"] = string.len(body)
	headers["Token"] = FNKY.token

    local response = HttpPost(url, body, headers, 10)
	DebugPrint("Ӧ", response)
	local response_body = jsonLib.decode(response)

    if FNKY.use_encryption then
        response_body = FNKY.decrypt_response(response_body)
    end

    return response_body
end

-- 
-- @param params: 
-- @return encrypted: ܺ
function FNKY.encrypt_request(params)
    -- ʵAESܺMD5ǩ
	DebugPrint(params)
	local plaintext = jsonLib.encode(params)
	DebugPrint(":",  plaintext)

	-- һ16ֽڵ
	local byteArray = {}
	for i = 1, 16 do
		byteArray[i] = string.char(0)  -- ÿֽڳʼΪ 0
	end
	-- ʼAESܹ
	AESUtilsBase.init(FNKY.encrypt_key, byteArray)
	-- ȡܽ
	local encrypt_result = AESUtilsBase.encrypt(plaintext)
	DebugPrint("ܽ:", encrypt_result)
	-- ȡǩ
	local signature = MD5(encrypt_result .. FNKY.encrypt_key)
	-- 
	local body = {
		["a"] = encrypt_result,
		["b"] = signature
	}
	return jsonLib.encode(body)
end

-- Ӧ
-- @param response_body: ܵӦ
-- @return decrypt_data: ܺ
function FNKY.decrypt_response(response_body)
	-- ǩ
	local signature_a = string.upper(MD5(response_body["a"] .. FNKY.encrypt_key))
	local signature_b = string.upper(response_body["b"])

	if (signature_a ~= signature_b) then
		error(RESPONSE["ERROR_SIGNATURE"])
	end

    -- ʵAES
	local decrypt_data = AESUtilsBase.decrypt(response_body["a"])

	-- תΪtable
	local decrypt_table = jsonLib.decode(decrypt_data)
	DebugPrint(":", decrypt_data)

	-- ȡݽжԱ
	local response_status = decrypt_table["Status"]
	local response_time = decrypt_table["Time"]
	-- Statusж
	if (response_status ~= FNKY.params.Status) then
		error(decrypt_table["Msg"])
	end
	-- ʱǷʱ
	if (response_time - FNKY.params.Time > TIMEOUT) then
		error(RESPONSE["ERROR_TIME"])
	end

	return decrypt_table
end





--------------------------úʼ----------------------------------




-- ʼtoken
function FNKY.init_token()
	if (FNKY.token == nil) then
		local token_response = FNKY.get_token()
		DebugPrint(token_response)
		FNKY.token = token_response["Data"]["Token"]
	end
end

-- ȡ豸
-- @return device_id: 豸
function FNKY.GetDeviceKey()
	-- MD5ܳ
	local function SecretKey(tb)
		local str = "FNKY";
		for i = 1, #tb, 1 do
			str = str .. "-" .. tb[i];
		end
		return string.upper(MD5(str));
	end

	local Model = exec("getprop ro.product.model")
	local Brand = exec("getprop ro.product.brand")
	local Serialno = exec("getprop ro.serialno")
	local ID = exec("getprop ro.build.id")
	local Device = exec("getprop ro.product.device")
	local CpuArch = exec("getprop ro.product.cpu.abi")

	return SecretKey({Model, Brand, Serialno, ID, Device, CpuArch})
end





--------------------------APIʼ----------------------------------





-- ȡToken
-- @return response: ȡTokenӦ
function FNKY.get_token()
    local params = {
    }
    return FNKY.send_request("GetToken", params)
end

-- û¼
-- @param user_or_ka: û򿨺
-- @param password: 
-- @param key: Ϣ
-- @param tab: ̬
-- @param app_ver: Ӧð汾
-- @return response: ¼Ӧ
function FNKY.login(user_or_ka, password, key, tab, app_ver)
    local params = {
        UserOrKa = user_or_ka,
        PassWord = password,
        Key = key,
        Tab = tab,
        AppVer = app_ver
    }
    return FNKY.send_request("UserLogin", params)
end

-- ûע
-- @param user: û
-- @param password: 
-- @param key: Ϣ
-- @param super_password: 
-- @param qq: QQ
-- @param email: 
-- @param phone: ֻ
-- @return response: עӦ
function FNKY.register(user, password, key, super_password, qq, email, phone)
    local params = {
        User = user,
        PassWord = password,
        Key = key,
        SuperPassWord = super_password,
        Qq = qq,
        Email = email,
        Phone = phone
    }
    return FNKY.send_request("NewUserInfo", params)
end

-- ȡûIP
-- @return response: ȡûIPӦ
function FNKY.get_user_ip()
    local params = {
    }
    return FNKY.send_request("GetUserIP", params)
end

-- ȡӦûϢ
-- @return response: ȡӦûϢӦ
function FNKY.get_app_info()
    local params = {
    }
    return FNKY.send_request("GetAppInfo", params)
end

-- û
-- @param money: ٵĽ
-- @param log: ԭ
-- @param agent_id: ID
-- @param agent_money: ֳɽ
-- @param agent_money_log: ֳԭ
-- @return response: Ӧ
function FNKY.reduce_money(money, log, agent_id, agent_money, agent_money_log)
    local params = {
        Money = money,
        Log = log,
        AgentId = agent_id,
        AgentMoney = agent_money,
        AgentMoneyLog = agent_money_log
    }
    return FNKY.send_request("UserReduceMoney", params)
end

-- ûٻ
-- @param vip_number: ٵĻ
-- @param log: ԭ
-- @param agent_id: ID
-- @param agent_money: ֳɽ
-- @param agent_money_log: ֳԭ
-- @return response: ٻӦ
function FNKY.reduce_vip_number(vip_number, log, agent_id, agent_money, agent_money_log)
    local params = {
        VipNumber = vip_number,
        Log = log,
        AgentId = agent_id,
        AgentMoney = agent_money,
        AgentMoneyLog = agent_money_log
    }
    return FNKY.send_request("UserReduceVipNumber", params)
end

-- ûٵ
-- @param vip_time: ٵĵ
-- @param log: ԭ
-- @return response: ٵӦ
function FNKY.reduce_vip_time(vip_time, log)
    local params = {
        VipTime = vip_time,
        Log = log
    }
    return FNKY.send_request("UserReduceVipTime", params)
end

-- ȡ״̬
-- @return response: ״̬Ӧ
function FNKY.server_link_status()
    local params = {
    }
    return FNKY.send_request("IsServerLink", params)
end

-- ȡ¼״̬
-- @return response: ¼״̬Ӧ
function FNKY.login_status()
    local params = {
    }
    return FNKY.send_request("IsLogin", params)
end

-- ȡӦVip
-- @return response: ӦVipӦ
function FNKY.get_vip_data()
    local params = {
    }
    return FNKY.send_request("GetVipData", params)
end

-- ȡӦù
-- @return response: ӦùӦ
function FNKY.get_app_announcement()
    local params = {
    }
    return FNKY.send_request("GetAppGongGao", params)
end

-- ȡר
-- @param name: 
-- @return response: רӦ
function FNKY.get_app_variable(name)
    local params = {
        Name = name
    }
    return FNKY.send_request("GetAppPublicData", params)
end

-- ȡ
-- @param name: 
-- @return response: Ӧ
function FNKY.get_public_variable(name)
    local params = {
        Name = name
    }
    return FNKY.send_request("GetPublicData", params)
end

-- ù
-- @param name: 
-- @param value: ֵ
-- @return response: ùӦ
function FNKY.set_public_variable(name, value)
    local params = {
        Name = name,
        Value = value
    }
    return FNKY.send_request("SetPublicData", params)
end

-- ȡ°汾
-- @param version: ǰ汾
-- @param is_version_all: Ƿ汾
-- @return response: °汾Ӧ
function FNKY.check_version(version, is_version_all)
    local params = {
        Version = version,
        IsVersionAll = is_version_all
    }
    return FNKY.send_request("GetAppVersion", params)
end

-- ȡ°汾صַ
-- @return response: °汾صַӦ
function FNKY.get_update_url()
    local params = {
    }
    return FNKY.send_request("GetAppUpDataJson", params)
end

-- ȡӦҳUrl
-- @return response: ӦҳUrlӦ
function FNKY.get_app_home_url()
    local params = {
    }
    return FNKY.send_request("GetAppHomeUrl", params)
end

-- °Ϣ
-- @param new_key: °Ϣ
-- @param user: û
-- @param password: 
-- @return response: °ϢӦ
function FNKY.set_new_user_key(new_key, user, password)
    local params = {
        NewKey = new_key,
        User = user,
        PassWord = password
    }
    return FNKY.send_request("SetAppUserKey", params)
end

-- ɾϢ
-- @param user: û
-- @param password: 
-- @return response: ɾϢӦ
function FNKY.delete_user_key(user, password)
    local params = {
        User = user,
        PassWord = password
    }
    return FNKY.send_request("DeleteAppUserKey", params)
end

-- ûϢ
-- @param msg_type: Ϣ
-- @param msg: Ϣ
-- @param password: 
-- @return response: ûϢӦ
function FNKY.set_new_user_msg(msg_type, msg, password)
    local params = {
        MsgType = msg_type,
        Msg = msg,
        PassWord = password
    }
    return FNKY.send_request("SetNewUserMsg", params)
end

-- ȡ֤
-- @param captcha_type: ֤
-- @return response: ȡ֤Ӧ
function FNKY.get_captcha(captcha_type)
    local params = {
        CaptchaType = captcha_type
    }
    return FNKY.send_request("GetCaptcha", params)
end

-- ύ֤
-- @param captcha: ֤
-- @return response: ύ֤Ӧ
function FNKY.submit_captcha(captcha)
    local params = {
        Captcha = captcha
    }
    return FNKY.send_request("SubmitCaptcha", params)
end

-- ȡ֤
-- @param phone: ֻ
-- @param user: û
-- @return response: ȡ֤Ӧ
function FNKY.get_sms_captcha(phone, user)
    local params = {
        Phone = phone,
        User = user
    }
    return FNKY.send_request("GetSMSCaptcha", params)
end

-- ȡϢ
-- @return response: ȡϢӦ
function FNKY.get_user_key()
    local params = {
    }
    return FNKY.send_request("GetAppUserKey", params)
end

-- ȡûǷ
-- @param user: û
-- @return response: ûǷӦ
function FNKY.check_user_exists(user)
    local params = {
        User = user
    }
    return FNKY.send_request("GetIsUser", params)
end

-- ȡûϢ
-- @return response: ûϢӦ
function FNKY.get_software_user_info()
    local params = {
    }
    return FNKY.send_request("GetAppUserInfo", params)
end

-- ȡûϢ
-- @return response: ûϢӦ
function FNKY.get_user_base_info()
    local params = {
    }
    return FNKY.send_request("GetUserInfo", params)
end

-- ûϢ
-- @param email: 
-- @param phone: ֻ
-- @param qq: QQ
-- @return response: ûϢӦ
function FNKY.set_user_base_info(email, phone, qq)
    local params = {
        Email = email,
        Phone = phone,
        Qq = qq
    }
    return FNKY.send_request("SetUserQqEmailPhone", params)
end

-- ȡϵͳʱ
-- @return response: ϵͳʱӦ
function FNKY.get_system_time()
    local params = {
    }
    return FNKY.send_request("GetSystemTime", params)
end

-- ȡûע
-- @return response: ûעӦ
function FNKY.get_app_user_note()
    local params = {
    }
    return FNKY.send_request("GetAppUserNote", params)
end

-- ȡԱʱ
-- @return response: ԱʱӦ
function FNKY.get_app_user_vip_time()
    local params = {
    }
    return FNKY.send_request("GetAppUserVipTime", params)
end

-- û¼ע
-- @return response: û¼עӦ
function FNKY.log_out()
    local params = {
    }
    return FNKY.send_request("LogOut", params)
end

-- û¼עԶ̣
-- @param user: û
-- @param passWord: 
-- @return response: û¼עԶ̣Ӧ
function FNKY.remote_log_out(user, passWord)
    local params = {
        User = user,
        PassWord = passWord
    }
    return FNKY.send_request("RemoteLogOut", params)
end

-- 
-- @return response: Ӧ
function FNKY.heart_beat()
    local params = {
    }
    return FNKY.send_request("HeartBeat", params)
end

-- һػ޸ģ룩
-- @param user: û
-- @param newPassWord: 
-- @param oldPassWord: 
-- @return response: һػ޸ģ룩Ӧ
function FNKY.old_pass_word_set_pass_word(user, newPassWord, oldPassWord)
    local params = {
        User = user,
        NewPassWord = newPassWord,
        OldPassWord = oldPassWord
    }
    return FNKY.send_request("OldPassWordSetPassWord", params)
end

-- һػ޸ģ룩
-- @param user: û
-- @param newPassWord: 
-- @param superPassWord: 
-- @return response: һػ޸ģ룩Ӧ
function FNKY.set_pass_word(user, newPassWord, superPassWord)
    local params = {
        Type = 1,
        User = user,
        NewPassWord = newPassWord,
        SuperPassWord = superPassWord
    }
    return FNKY.send_request("SetPassWord", params)
end

-- һػ޸ģֻ
-- @param user: û
-- @param newPassWord: 
-- @param phoneCaptchaId: ֤Id
-- @param phoneCaptchaValue: ֵ֤
-- @return response: һػ޸ģֻӦ
function FNKY.sms_code_set_pass_word(user, newPassWord, phoneCaptchaId, phoneCaptchaValue)
    local params = {
        User = user,
        NewPassWord = newPassWord,
        PhoneCaptchaId = phoneCaptchaId,
        PhoneCaptchaValue = phoneCaptchaValue
    }
    return FNKY.send_request("SmsCodeSetPassWord", params)
end

-- ȡû
-- @return response: ûӦ
function FNKY.get_user_rmb()
    local params = {
    }
    return FNKY.send_request("GetUserRmb", params)
end

-- ȡû
-- @return response: ûӦ
function FNKY.get_app_user_vip_number()
    local params = {
    }
    return FNKY.send_request("GetAppUserVipNumber", params)
end

-- ȡ֤ӿб
-- @return response: ֤ӿбӦ
function FNKY.get_captcha_api_list()
    local params = {
    }
    return FNKY.send_request("GetCaptchaApiList", params)
end

-- ųֵ
-- @param user: û
-- @param ka: 
-- @param inviteUser: Ƽ
-- @return response: ųֵӦ
function FNKY.use_ka(user, ka, inviteUser)
    local params = {
        User = user,
        Ka = ka,
        InviteUser = inviteUser
    }
    return FNKY.send_request("UseKa", params)
end

-- ȡ̬
-- @return response: ̬Ӧ
function FNKY.get_tab()
    local params = {
    }
    return FNKY.send_request("GetTab", params)
end

-- ö̬
-- @param tab: ̬
-- @return response: ö̬Ӧ
function FNKY.set_tab(tab)
    local params = {
        Tab = tab
    }
    return FNKY.send_request("SetTab", params)
end

-- 
-- @param money: ҪѵĽ
-- @return response: Ӧ
function FNKY.pay_money_to_vip_number(money)
    local params = {
        Money = money
    }
    return FNKY.send_request("PayMoneyToVipNumber", params)
end

-- ȡɹб
-- @return response: ɹбӦ
function FNKY.get_pay_ka_list()
    local params = {
    }
    return FNKY.send_request("GetPayKaList", params)
end

-- ֵ
-- @param kaClassId: ҪĿID
-- @return response: ֵӦ
function FNKY.pay_money_to_ka(kaClassId)
    local params = {
        KaClassId = kaClassId
    }
    return FNKY.send_request("PayMoneyToKa", params)
end

-- ȡѹ򿨺б
-- @param number: ȡļ
-- @return response: ѹ򿨺бӦ
function FNKY.get_purchased_ka_list(number)
    local params = {
        Number = number
    }
    return FNKY.send_request("GetPurchasedKaList", params)
end

-- ȡûб
-- @return response: ûбӦ
function FNKY.get_user_class_list()
    local params = {
    }
    return FNKY.send_request("GetUserClassList", params)
end

-- û
-- @param mark: û
-- @return response: ûӦ
function FNKY.set_user_class(mark)
    local params = {
        Mark = mark
    }
    return FNKY.send_request("SetUserClass", params)
end

-- js
-- @param jsName: js
-- @param parameter: jsβ
-- @param isGlobal: ΪȫֵΪ,ӦרֵΪ
-- @return response: jsӦ
function FNKY.run_js(jsName, parameter, isGlobal)
    local params = {
        JsName = jsName,
        Parameter = parameter,
        IsGlobal = isGlobal
    }
    return FNKY.send_request("RunJS", params)
end

-- _񴴽
-- @param task_type_id: ID
-- @param parameter: 
-- @return response: 񴴽Ӧ
function FNKY.task_pool_new_data(task_type_id, parameter)
    local params = {
        TaskTypeId = task_type_id,
        Parameter = parameter
    }
    return FNKY.send_request("TaskPoolNewData", params)
end

-- _ȡ
-- @param get_task_number: ȡ
-- @param get_task_type_id_array: ҪȡID
-- @return response: ȡӦ
function FNKY.task_pool_get_task(get_task_number, get_task_type_id_array)
    local params = {
        GetTaskNumber = get_task_number,
        GetTaskTypeId = get_task_type_id_array
    }
    return FNKY.send_request("TaskPoolGetTask", params)
end

-- _
-- @param task_uuid: UUID
-- @param task_status: ״̬
-- @param task_return_data: 񷵻
-- @return response: صӦ
function FNKY.task_pool_set_task(task_uuid, task_status, task_return_data)
    local params = {
        TaskUuid = task_uuid,
        TaskStatus = task_status,
        TaskReturnData = task_return_data
    }
    return FNKY.send_request("TaskPoolSetTask", params)
end

-- _ֱ
-- @param user: û˺Ż򿨺
-- @param ka_class_id: ID
-- @param pay_type: ֧
-- @return response: ֱ嶩Ӧ
function FNKY.pay_ka_use(user, ka_class_id, pay_type)
    local params = {
        User = user,
        KaClassId = ka_class_id,
        PayType = pay_type
    }
    return FNKY.send_request("PayKaUsa", params)
end

-- _֧
-- @param ka_class_id: ID
-- @param pay_type: ֧
-- @return response: ֧Ӧ
function FNKY.pay_get_ka(ka_class_id, pay_type)
    local params = {
        KaClassId = ka_class_id,
        PayType = pay_type
    }
    return FNKY.send_request("PayGetKa", params)
end

-- _
-- @param user: û˺
-- @param money: ֵ
-- @param pay_type: ֧
-- @return response: Ӧ
function FNKY.pay_user_money(user, money, pay_type)
    local params = {
        User = user,
        Money = money,
        PayType = pay_type
    }
    return FNKY.send_request("PayUserMoney", params)
end

-- ֵ_ȡ֧ͨ״̬
-- @return response: ֧ͨ״̬Ӧ
function FNKY.get_pay_status()
    local params = {}
    return FNKY.send_request("GetPayStatus", params)
end

-- _
-- @param user: û˺
-- @param money: ֵ
-- @param pay_type: ֧
-- @return response: ֶӦ
function FNKY.pay_user_vip_number(user, money, pay_type)
    local params = {
        User = user,
        Money = money,
        PayType = pay_type
    }
    return FNKY.send_request("PayUserVipNumber", params)
end

-- _ȡ״̬ѯ
-- @param order_id: 
-- @return response: ״̬ѯӦ
function FNKY.get_pay_order_status(order_id)
    local params = {
        OrderId = order_id
    }
    return FNKY.send_request("GetPayOrderStatus", params)
end

-- û_ֵ
-- @param name: 
-- @param value: ֵ
-- @return response: ûֵӦ
function FNKY.set_user_config(name, value)
    local params = {
        Name = name,
        Value = value
    }
    return FNKY.send_request("SetUserConfig", params)
end

-- û_ȡֵ
-- @param name: 
-- @return response: ûȡֵӦ
function FNKY.get_user_config(name)
    local params = {
        Name = name
    }
    return FNKY.send_request("GetUserConfig", params)
end

-- ô־
-- @param agent_uid: ˺Uid
-- @param promotion_code: ˺ƹ
-- @return response: ô־Ӧ
function FNKY.set_agent_uid(agent_uid, promotion_code)
    local params = {
        AgentUid = agent_uid,
        PromotionCode = promotion_code
    }
    return FNKY.send_request("SetAgentUid", params)
end

-- ȡ
-- @param ka: 
-- @return response: Ӧ
function FNKY.get_ka_info(ka)
    local params = {
        Ka = ka
    }
    return FNKY.send_request("GetKaInfo", params)
end





--------------------------ߺʼ----------------------------------





-- ԭPost
function HttpPost(url, data, headers, timeout)
	local http = require("socket.http")
	local ltn12 = require("ltn12")
	local socket = require "socket"
	local request_body = data
	local request_headers = headers or {
			["Content-Type"] = "application/json; charset=utf-8";
			["Content-Length"] = string.len(request_body);
		}

	local response_body = {}
	http.TIMEOUT = timeout or 30
	local res, code, response_headers = http.request{
		url = url,
		method = "POST",
		headers = request_headers,
		source = ltn12.source.string(request_body),
		sink = ltn12.sink.table(response_body),
	}
    return table.concat(response_body)
end

-- 
function DebugPrint(...)
	if (DEBUG) then
		print(...)
	end
end

return FNKY
