function try(block)
    local tablejoin = function(...)
        local result = {}
        for _, t in ipairs({...}) do
            if type(t) == "table" then
                for k, v in pairs(t) do
                    if type(k) == "number" then
                        table.insert(result, v)
                    else
                        result[k] = v
                    end
                end
            else
                table.insert(result, t)
            end
        end
        return result
    end

    local try = block[1]
    assert(try)

    local funcs = tablejoin(block[2] or {}, block[3] or {})

    local result_error = {}
    local results = {pcall(try)}
    if not results[1] then
        -- run the catch function
        if funcs and funcs.catch then
            result_error = {funcs.catch(results[2])}
        end
    end

    if funcs and funcs.finally then
        local result_fin = {funcs.finally(table.unpack(results))}
        if #result_fin > 0 then return table.unpack(result_fin) end
    end

    if results[1] and #results > 1 then
        return table.unpack(results, 2, #results)
    else
        if #result_error > 0 then
            return table.unpack(result_error)
        else
            return nil
        end
    end
end

function catch(block) return {catch = block[1]} end

function finally(block) return {finally = block[1]} end
